// gs_common.h

// Contains everything that is shared amongst the library files. It should be included
// by every header of the lib.

#ifndef GS_COMMON_H
#define GS_COMMON_H

// Include all the DirectX files we need for the entire library. This is to make
// sure the compiler doesn't use the ones that come with VC.
#include "..\directx\include\d3dtypes.h"
#include "..\directx\include\ddraw.h"
#include "..\directx\include\dinput.h"
#include "..\directx\include\dls1.h"

//#include "..\directx\include\dmdls.h"
//#include "..\directx\include\dmusbuff.h"
#include "..\directx\include\dmusicc.h"
#include "..\directx\include\dmusici.h"

//#include "..\directx\include\dsound.h"

// Define GS_CAUSE_ASSERT if you want the code to assert whenever an error occurs.
// This can be useful if you want to see the state of certain variables when an
// error occurs. Used in QuitMsg().
/*#define GS_CAUSE_ASSERT*/

// When compiling in debug mode, define GS_DEBUG
#ifdef _DEBUG
	#define GS_DEBUG
#endif

// Common defines and typedefs
#define MAX_STRING_LENGTH     255

typedef enum {FULLSCREEN, WINDOWED} tDisplayMode;

// Common functions
extern "C" void QuitMsg(int objectID, char function[], char message[], ...); // Logs and displays message, then quits
extern "C" inline void DebugMsg(int objectID, char function[], char message[], ...); // Logs message
extern "C" inline int GetObjectID(); // Gets a unique ID
extern "C" inline char* SetRelativePath(char relative_path[]);
extern "C" inline char* SetFullPath(char full_path[]);


// In debug mode, include debugging functionality
#ifdef GS_DEBUG
	#include "gs_debug.h"
#endif

#endif
