// gs_debug.h

// Contains common debugging functions for the library.

#ifndef GS_DEBUG_H
#define GS_DEBUG_H

#include "gs_common.h"

// Function prototypes

// Used by all objects

// Used by DirectDrawObject
extern "C" inline void ValidateCopyRect(RECT &CopyRect, int ID, char FuncName[]);
extern "C" inline void ValidateSurfaceExists(LPDIRECTDRAWSURFACE4 Surface, char SurfType, int ID, char FuncName[]);
extern "C" inline void ValidateSourceSurfaceExists(LPDIRECTDRAWSURFACE4 Surface, char SurfType, int ID, char FuncName[]);
extern "C" inline void ValidateSourceSurfaceTiled(RECT *TileRects, int ID, char FuncName[]);
extern "C" inline void ValidateDisplayDevice(int device_num, int MaxDevices, int ID, char FuncName[]);

// Used by DirectSoundObject
extern "C" inline void ValidateWaveNumber(int wave_num, int max_sounds, LPDIRECTSOUNDBUFFER buffer, int ID, char FuncName[]);

#endif