// gs_deviceenumerator.h

#ifndef GS_DEVICEENUMERATOR_H
#define GS_DEVICEENUMERATOR_H

// Includes
#include "gs_common.h"

// Defines and typedefs

// Struct used to hold information of enumerated display devices
typedef struct
{
	LPGUID lpGuid;
	char DriverDescription[MAX_STRING_LENGTH<<1];
	char DriverName[MAX_STRING_LENGTH<<1];
} tDisplayDeviceInfo;


// Enumertaion function declarations
BOOL WINAPI EnumDDrawDevice(GUID FAR*, LPSTR, LPSTR, LPVOID);
BOOL WINAPI EnumDDrawDeviceEx(GUID FAR*, LPSTR, LPSTR, LPVOID, HMONITOR);


//**********************************************************************
// Use this class to create an object that checks if multiple devices
// exist. You can then pass the device number to the PrimarySurfaceObject
// instance.
class DisplayDeviceEnumerator
{
	// Friend function declarations
	friend BOOL WINAPI EnumDDrawDevice(GUID FAR*, LPSTR, LPSTR, LPVOID);
	friend BOOL WINAPI EnumDDrawDeviceEx(GUID FAR*, LPSTR, LPSTR, LPVOID, HMONITOR);

	public:

		// Constructor/Destructor
		DisplayDeviceEnumerator();
		~DisplayDeviceEnumerator();

		int GetNumDevices();						// Returns the number of display devices on this system
		char* GetDeviceDescription(int device_num); // Returns the name of device device_num (0-based)

		void SetDevice(int device_num);	// Sets the device number to use
		int GetDevice();				// Returns the device that was set
		LPGUID GetDeviceGUID();			// Returns the current device's GUID


	private:

		void EnumerateDevices();

		// The following two members are static because they must be accessed by the two global
		// callback functions used for enumeration.
		static int m_NumDevices;							// The number of valid display devices
		static tDisplayDeviceInfo *m_pDisplayDeviceInfo;	// Array of structs that hold information about the devices
		int m_DeviceInfoIndex;								// Index into m_pDeviceInfo

		int m_CurrDisplayDevice; // The current display device the user set

		int m_ID;
};


#endif