// gs_directdraw.h

#ifndef GS_DIRECTDRAW_H
#define GS_DIRECTDRAW_H

// Includes
#include <fstream>
#include <cstdio>

#include "gs_common.h"
#include "gs_debug.h"
#include "gs_winstandard.h"
#include "gs_font.h"
#include "gs_deviceenumerator.h"

// Defines
#define COLOR_BITS			16

 // Let DirectDrawObject know that the following classes exist (for friends)
class GenericSurfaceObject;
class DisplaySurfaceObject;
class PrimarySurfaceObject;
class WindowSurfaceObject;


//**********************************************************************
// A singleton class used to initialize the DirectDraw environment and manage
// relative data.
class DirectDrawObject
{
	 // The following classes can access DirectDrawObject's private members
	friend GenericSurfaceObject;
	friend DisplaySurfaceObject;
	friend PrimarySurfaceObject;
	friend WindowSurfaceObject;

	public:

		static DirectDrawObject* Instance(); // Use this function to retrieve the single instance of this object
		static void DestroyInstance(); // Destroys the instance
		static bool IsInstantiated(); // Returns true if this object was instatiated


		~DirectDrawObject(); // Public Destructor

		void Create(int screen_width, int screen_height, char graphics_path[]=".", DisplayDeviceEnumerator *pDeviceEnumerator=NULL);
		bool IsCreated(); // Returns true if the object has been created

		// Some basic inspectors
		int GetScreenWidth();	// Returns the screen width
		int GetScreenHeight();	// Returns the screen height

		// Set the graphics directory for the Load functions on surface objects
		void SetGraphicsDirectory(char path[], bool relative_path=true);

		// Functions called by GSWinUpdate() (defined in gs_helper.h)
		void LostWinFocus(); // Called when the window loses focus
		bool GotWinFocus(); // Called when the window regains the focus


	private:
		DirectDrawObject(); // Private Constructor
		static DirectDrawObject *m_pDirectDrawObject; // Pointer to single instance

		// Private member functions
		void SetDisplayMode(HWND hwnd, tDisplayMode display_mode=FULLSCREEN);

		LPDIRECTDRAW4 m_pDDraw;				// Pointer to the DIRECTDRAW object
		char *m_pGraphicsDir;				// Will hold the path where to load all graphics
		int m_ScreenWidth, m_ScreenHeight;	// The screen width and height

		bool m_UsingSecondaryDevice;		// true if displaying on a different device

		int m_ID; // The Object ID
};

#endif