// gs_directinput.h

// Contains classes that deal with input (i.e. keyboard input).

#ifndef GS_DIRECTINPUT_H
#define GS_DIRECTINPUT_H

// Make compatibly with DirectX 3
#undef DIRECTINPUT_VERSION
#define DIRECTINPUT_VERSION 0x0300

#include "gs_common.h"

// Class declarations
class KeyboardObject;

//**********************************************************************
// A singleton class used to initialize the DirectInput environment
class DirectInputObject
{
	friend KeyboardObject; // KeyboardObject needs special access to DirectInputObject

	public:

		static DirectInputObject* Instance(); // Use this function to retrieve the single instance of this object
		static void DestroyInstance(); // Destroys the instance
		static bool IsInstantiated(); // Returns true if this object was instatiated

		~DirectInputObject(); // Destructor

		void Create(HINSTANCE hInstance);
		bool IsCreated(); // Returns true if the object has been created

	private:

		DirectInputObject(); // Private constructor
		static DirectInputObject *m_pDirectInputObject; // Pointer to single instance

		LPDIRECTINPUT m_pDirectInput; // DirectInput interface

		int m_ID; // The Object ID
};




/*
//**********************************************************************
class JoystickObject
{
	public:
		JoystickObject(); // Constructor Make sure to call Create()
		~JoystickObject(); // Destructor

		void Create();

	private:
		LPDIRECTINPUTDEVICE2 Joystick;
};
*/

#endif
