// gs_directmusic.h

#ifndef GS_DIRECTMUSIC_H
#define GS_DIRECTMUSIC_H

#include "gs_common.h"
#include "gs_directsound.h"

// Defines and typedefs
#define MAX_MIDIS							10
typedef struct { IDirectMusicSegment *Segment;} LPIDirectMusicSegment;

//**********************************************************************
// A singleton class used to initialize the DirectMusic environment and
// manage playback of midi files.
class DirectMusicObject
{
	public:
		
		static DirectMusicObject* Instance(); // Use this function to retrieve the single instance of this object
		static void DestroyInstance(); // Destroys the instance
		static bool IsInstantiated(); // Returns true if this object was instatiated		
		

		~DirectMusicObject(); // Public destructor

		void Create(char relative_path[]=".", int max_midis=MAX_MIDIS);
		bool IsCreated(); // Returns true if the object has been created		

		void SetMidiDirectory(char path[], bool relative_path=true);

		void AddMidi(char filename[]);
		void RemoveMidi();

		void PlayMidi(int midi_number);
		void StopMidi(); // This stops the midi and resets the start time to 0
		void PauseMidi(); // This pauses the midi and remembers it's stop time

		void RepeatMidi(); // Call this in game loop to loop current midi

		bool LostWinFocus(); // Call if application loses keyboard focus
		bool GotWinFocus(); // Call when application regains keyboard focus


	private:

		DirectMusicObject(); // Private constructor
		static DirectMusicObject *m_pDirectMusicObject; // Pointer to single instance

		IDirectMusic *m_pDirectMusic; // DirectMusic object
		IDirectMusicPerformance *m_pPerf; // Performance object
		IDirectMusicSegmentState *m_pSegmentState;
		LPIDirectMusicSegment *m_pSegmentList; // Will contain all loaded midis
		IDirectMusicLoader *m_pLoader; // Loader object

		MUSIC_TIME *m_pMidiTime; // Time at which each midi was at when it's paused

		int m_NumMidis; // Current number of midis loaded
		int m_CurrMidi; // Current midi that's playing
		int m_MaxMidis; // Max number of midis that can be loaded
		bool m_Playing; // True if music is supposed to be playing

		int m_ID; // The Object ID
};


#endif
