// gs_directsound.h

// Contains classes that enable music and sound.

#ifndef GS_DIRECTAUDIO_H
#define GS_DIRECTAUDIO_H

// Includes
#include <cstdio>

#include "gs_common.h"

// Defines and typedefs
#define MAX_WAVES							30
#define MAX_MIX 							5

typedef struct { LPDIRECTSOUNDBUFFER Buffer; bool Looping; bool Playing;} tSound;

// Class declarations
class DirectMusicObject;

//**********************************************************************
// A singleton class used to initialize the DirectSound environment and
// manage playback of wave files.
class DirectSoundObject
{
	friend DirectMusicObject; // DirectMusicObject needs special access to DirectSoundObject

	public:

		static DirectSoundObject* Instance(); // Use this function to retrieve the single instance of this object
		static void DestroyInstance(); // Destroys the instance
		static bool IsInstantiated(); // Returns true if this object was instatiated		

		~DirectSoundObject(); // Public Destructor

		// Note: max_mix = maximum number of waves to play at the same time (using MixWave() method)
		void Create(HWND hwnd, char relative_path[]=".", int max_waves=MAX_WAVES, int max_mix=MAX_MIX, int sample_rate=22050, int sample_size=16, int channels=1);
		bool IsCreated(); // Returns true if the object has been created

		void SetWaveDirectory(char path[], bool relative_path=true);

		void AddWave(char filename[]);	// Adds a wave to the next available slot automatically
		void RemoveWave();			// Removes the last wave that was added

		void AddWave(char filename[], int wave_num);	// Adds a wave at slot wave_num
		void RemoveWave(int wave_num);					// Removes a wave from slot wave_num

		void PlayWave(int wave_num, bool loop=false);	// Plays wave_num, and loops it if loop is true
		void StopWave(int wave_num);					// Stops playing wave_num

		void PauseWave(int wave_num);					// Pauses wave_num
		void ResumeWave(int wave_num);					// Resumes a paused wave

		void MixWave(int wave_num); // Uses this function to mix the same wave max_mix times

		bool IsPlaying(int wave_num); // Returns true if wave_num is playing
		bool IsLooping(int wave_num); // Returns true if wave_num is looping

		bool LostWinFocus();
		bool GotWinFocus();

	private:

		DirectSoundObject(); // Private constructor
		static DirectSoundObject *m_pDirectSoundObject; // Pointer to single instance

		LPDIRECTSOUND m_pDirectSound; // Main DirectSound object

		char *m_pWaveDir; // Where the wave files are stored

		// For playing waves by index number
		tSound *m_pSounds; // Direct Sound Buffer array
		int m_NumSounds; // How many sounds currently loaded
		int m_MaxSounds; // Maximum number of sounds that can be loaded

		// For mixing waves
		LPDIRECTSOUNDBUFFER *m_pMixQueue; // Circular sound buffer
		int m_MaxMix; // Number of max sounds to play concurrently
		int m_CurrMixIndex; // Current sound to play

		LPDIRECTSOUNDBUFFER m_pPrimarySoundBuffer; // The Primary Sound buffer

		int m_ID; // The Object ID
};


#endif