// gs_font.h

#ifndef GS_FONT_H
#define GS_FONT_H

// Includes
#include "gs_common.h"


// Defines

// Fonts (standard ones on all versions of Windows)
#define FONT_VERDANA			"Verdana"
#define FONT_TIMES_NEW_ROMAN	"Times New Roman"
#define FONT_COMIC_SANS_MS		"Comic Sans MS"
#define FONT_COURIER			"Courier"
#define FONT_COURIER_NEW		"Courier New"
#define FONT_ARIAL				"Arial"
#define FONT_SYMBOL 			"Symbol"

// Colors
// (NOTE, format = 0x00BBGGRR)
#define TEXT_WHITE			0x00FFFFFF
#define TEXT_BLACK			0x00000000
#define TEXT_RED			0x000000FF
#define TEXT_GREEN			0x0000FF00
#define TEXT_BLUE			0x00FF0000
#define TEXT_YELLOW			0x0000FFFF
#define	TEXT_LIGHTBLUE		0x00FFFF00
#define TEXT_MAGENTA		0x00FF00FF


//**********************************************************************
class FontObject
{
	public:

		FontObject(); // Constructor
		~FontObject(); // Destructor

		// Call this to create the font object; you must specify at least the font
		// name, and the height
		void Create(char font_name[], int height, COLORREF text_color=TEXT_WHITE, 
					COLORREF bk_color=TEXT_BLACK, bool bk_transparent=true,
					bool bold=false, bool italic=false, bool underline=false, bool strikeout=false);

		void SetFont(char font_name[]); // To change to a new font
		void SetHeight(int height); // To change to a new height
		void SetColors(COLORREF text_color, COLORREF bk_color); // To change the colors
		void SetBkTransparent(bool bk_transparent); // True for transparent background
		void SetAttributes(bool bold=false, bool italic=false, bool underline=false, bool strikeout=false);

		bool IsValid(); // Returns true if the FontObject has been created properly
		void PrepareHDC(HDC *pHDC); // Prepares the HDC of a window with the FontObject's parameters

	private:

		// Private member functions

		void UpdateFont(); // Updates the font object with the current state

		// Private Data members
		HFONT hFont; // Handle to the font object

		int Height; // Height of the font
		char *FontName; // The font's name
		COLORREF TextColor, TextBkColor; // Text and Text background colors
		bool TextBkTransparent; // Is background transparent

		bool Bold, Italic, Underline, Strikeout; // Attributes of the font

		int m_ID; // The Object ID
};


#endif