// gs_helper.h

// This file contains useful helper functions available to the user of the library.
// These functions allow to user to initialize all the main components of the
// library and provides functions to make the application work well within the
// Windows environment.

#ifndef GS_HELPER_H
#define GS_HELPER_H

#include <windows.h>

#include "gs_common.h"
#include "gs_directdraw.h"
#include "gs_surface.h"
#include "gs_directsound.h"
#include "gs_directmusic.h"
#include "gs_directinput.h"
#include "gs_keyboard.h"
#include "gs_timer.h"
#include "gs_winstandard.h"
#include "gs_helper.h"


// Define GS_USING_DEBUGGER when tracing through the code with a debugger
// This flag will stop the application from waiting for the focus to return to it
// when it loses it (which happens when you use a debugger). It is used in
// GSWinUpdate().
/*#define GS_USING_DEBUGGER*/

// The following set of GSInit*() functions are helper functions that initialize certain
// aspects of the library in a very standard way. If you need more control over such
// initialization, then you should do it yourself.

extern "C" void GSInitGraphics
	(
		HINSTANCE hInstance,							// Handle to the instance of the application
		int screen_width,								// Width of screen
		int screen_height,								// Height of screen
		tDisplayMode display_mode,						// FULLSCREEN or WINDOWED
		LPCSTR window_caption,							// Title of the window
		char graphics_path[] = ".",						// Relative directory where graphics are stored
		DisplayDeviceEnumerator *pDeviceEnum = NULL,	// Set to NULL if not to be used
		DirectDrawObject **ppDDrawObject = NULL,		// Will store the singleton in this pointer if passed
		PrimarySurfaceObject **ppPrimSurfObject = NULL	// Will store the singleton in this pointer if passed
	);

extern "C" void GSInitInput
	(
		HINSTANCE hInstance,						// Handle to the instance of the application
		HWND hwnd,									// Handle to the window that will receive input
		DirectInputObject **ppDInputObject = NULL,	// Will store the singleton in this pointer if passed
		KeyboardObject **ppKeyboardObject = NULL	// Will store the singleton in this pointer if passed
	);

extern "C" void GSInitAudio
	(
		HWND hwnd,									// Handle to the window that will receive input
		char waves_path[] = ".",					// Relative directory where wave files are stored
		char midis_path[] = ".",					// Relative directory where midi files are stored
		DirectSoundObject **ppDSoundObject = NULL,	// Will store the singleton in this pointer if passed
		DirectMusicObject **ppDMusicObject = NULL	// Will store the singleton in this pointer if passed
	);


// Function to call during the main game loop as well as waiting loops so that DirectX works with Windows
extern "C" void GSWinUpdate();


#endif
