// gs_keyboard.h

#ifndef GS_KEYBOARD_H
#define GS_KEYBOARD_H

#include "gs_common.h"
#include "gs_directinput.h"

//**********************************************************************
// A singleton class used to manage keyboard input
class KeyboardObject
{
	public:

		static KeyboardObject* Instance(); // Use this function to retrieve the single instance of this object
		static void DestroyInstance(); // Destroys the instance
		static bool IsInstantiated(); // Returns true if this object was instatiated

		~KeyboardObject(); // Destructor

		void Create(HWND hwnd); // Must call to create the KeyboardObject
		bool IsCreated(); // Returns true if the object has been created

		// Intantaneous input
		bool KeyDown(int key); // Returns true if key is being pressed
		bool KeyUp(int key); // Returns true if key was just released

		void WaitKeyUp(int key); // Doesn't return until key is pressed

		// Buffered input
		int GetKeyUp(char key_name[] = NULL); // Returns the key just released

		void GetKeyName(int key, char key_name[]); // Stores the key name of key into key_name

		bool IsAlpha(int key); // Returns true if key is in the alphabet
		bool IsNumeric(int key); // Returns true if key is a number
		bool IsAlphaNum(int key); // Returns true if key is either in the alphabet or a number

		void FlushBuffer(); // Empties out the input buffer

		bool LostWinFocus(); // Call if application loses keyboard focus
		bool GotWinFocus(); // Call when application regains keyboard focus


	private:

		KeyboardObject(); // Private constructor
		static KeyboardObject *m_pKeyboardObject; // Pointer to single instance

		LPDIRECTINPUTDEVICE m_pKeyboard; // The Keyboard device

		char m_KeyState[256];
		int m_LastKey; // Used by KeyDown/KeyUp functions

		// For buffered input
		char m_BufferSize;
		DIDEVICEOBJECTDATA *m_pDIDevObjectData;
		DWORD m_Items;
		DIDEVICEOBJECTINSTANCE m_DIDevObjectInstance;

		int m_ID; // The Object ID
};


#endif