// gs_timer.h

// Contains a timer class.

#ifndef GS_TIMER_H
#define GS_TIMER_H

#include <ctime>
#include <cstdio>

#define MAX_STRING_LENGTH	255

//**********************************************************************
class TimerObject
{
	public:
		TimerObject(); // Constructor
		
		void Start(); // Starts the timer
		int Stop();   // Stops the timer and returns the number of clocks since start

		int GetClocks(); // Returns number of clocks since start
		double GetSeconds(); // Returns the number of seconds since start

		char* GetClocksString(); // Returns the number of clocks since start in string format
		char* GetSecondsString(); // Returns the number of seconds since start in string format    


	private:
		clock_t StartTime, StopTime;
		char string[MAX_STRING_LENGTH];
};

#endif