// EventTest.java 
// Programmer: Antonio Maiorano (maioran@cs.concordia.ca)
// Date: Februray 10, 2002
//
// This program presents a possible implementation of
// an Event synchronization object, class Event in this
// case. It is different from a standard semaphore in that
// Wait() always blocks the calling thread, and Signal()
// wakes up all the blocked threads.

// Represents an Event
class Event {
	public synchronized void Wait(Thread t) {
		// Block calling thread
		try {
			wait();
		} catch (InterruptedException e) {}
	}

	public synchronized void Signal() {
		// Wake up all threads
		notifyAll();
	}
}

// Thread that will wait on an Event
class WaitForEvent extends Thread {
	String name;
	Event event;

	public WaitForEvent(String name, Event event) {
		this.name = name;
		this.event = event;
	}

	public void run() {
		System.out.println(name + ": waiting for event");
		event.Wait(this); // Wait on event for this thread
		System.out.println(name + ": event has occured!");
	}
}

// Thread that will signal an Event
class TriggerEvent extends Thread {
	Event event;

	public TriggerEvent(Event event) {
		this.event = event;
	}

	public void run() {
		// After some arbitrary waiting time, trigger the event
		for (int i=0; i<100; ++i) {
			System.out.print(".");
		}
		System.out.println();
		event.Signal();
	}
}

// Main entry point
public class EventTest {
	public static void main(String[] args) {
		// Declare an event that will be triggered when a key
		// is pressed
		Event keyPress = new Event();

		Thread[] threads = new Thread[4];

		// Create threads that will wait on the key press
		threads[0] = new WaitForEvent("T1", keyPress);
		threads[1] = new WaitForEvent("T2", keyPress);
		threads[2] = new WaitForEvent("T3", keyPress);

		// Create thread that will trigger the key press
		threads[3] = new TriggerEvent(keyPress);

		// Add threads to the ready queue
		for (int i=0; i<threads.length; ++i)
			threads[i].start();

		// Wait for the threads to finish
		for (int i=0; i<threads.length; ++i) {
			try { threads[i].join(); }
			catch (InterruptedException e) {}
		}

	}
}

