///////////////////////////////////////////////////////////////////////
// Scheduling.java
// Antonio Maiorano
// February 3, 2002
//
// This program demonstrates Java's scheduling policy: priority 
// scheduling with round-robin within priority levels. 
// 
// To see the difference between the "old" Java (1.2.1 and prior) 
// and the "new" Java (1.2.2 and later), log onto Alpha and do 
// the following: 
// 
// To test 1.2.1: 
// 
// /pkg/java-1.2.1/bin/java Scheduling 
// 
// To test 1.2.2: 
// 
// /bin/java Scheduling 
// 
///////////////////////////////////////////////////////////////////////

// Thread objects that simply output a character a 
// given number of times
class MyThread extends Thread {
	char outChar; // Character to output
	int numIters; // How many times to output

	public MyThread(char outChar, int numIters) {
		this.outChar = outChar;
		this.numIters = numIters;
	}

	public void run() {
		for (int i=0; i<numIters; ++i)
			System.out.print(outChar);
	}
}

// The scheduler manages when and how long threads are run
class Scheduler {
	MyThread[] readyQueue;

	Scheduler(MyThread[] readyQueue) {
		this.readyQueue = readyQueue;
	}

	void schedule() {
		for (int i=0; i<readyQueue.length; ++i) {
			readyQueue[i].start();
		}

		try {
			for (int i=0; i<readyQueue.length; ++i)
				readyQueue[i].join();
		} catch (InterruptedException e) { }
	}
}

// The main class
public class Scheduling {
	public static void main(String[] args) {

		MyThread[] readyQueue = new MyThread[3];
		Scheduler scheduler = new Scheduler(readyQueue);

		readyQueue[0] = new MyThread('*', 300);
		readyQueue[1] = new MyThread('~', 300);
		readyQueue[2] = new MyThread('_', 300);

		System.out.println("\nRunning Scheduler using FCFS:");
		scheduler.schedule();


		readyQueue[0] = new MyThread('*', 300);
		readyQueue[1] = new MyThread('~', 300);
		readyQueue[2] = new MyThread('_', 300);

		System.out.println("\n\nRunning Scheduler using Priority Scheduling:");
		readyQueue[0].setPriority(Thread.MIN_PRIORITY);
		readyQueue[1].setPriority(Thread.MAX_PRIORITY);
		readyQueue[2].setPriority(Thread.NORM_PRIORITY);
		scheduler.schedule();

		System.out.println();
	}
}

