#include <string.h>
#include <stdio.h>

struct String
{
	char* pStr;
	int length;
};

void ConstructString(String& rString, int size)
{
	rString.pStr = new char[size];
	rString.length = 0; // Nothing in string yet
}

void DestructString(String& rString)
{
	delete [] rString.pStr;
}

void SetString(String& rString, char str[])
{
	strcpy(rString.pStr, str);
	rString.length = strlen(str);
}

int GetStringLength(String& rString)
{
	return rString.length;
}

void PrintString(String& rString)
{
	printf("%s\n", rString.pStr);
}

void main()
{
	String myName; // Declare a String "object"

	ConstructString(myName, 50); // Create the String
	SetString(myName, "Tony"); // Set a value in it

	int length = GetStringLength(myName); // Get the length
	printf("Length: %d\n", length);

	PrintString(myName); // Output the String

	DestructString(myName); // Destroy the String
}
