#include <stdio.h>

class CThread
{
	public:
		int StartThread()
		{
			// Call pure virtual function
			return Run();
		}

		// This must be implemented in children
		virtual int Run() = 0;
};

class CMySillyThread : public CThread
{
	// Implement parent's pure virtual function
	virtual int Run()
	{
		printf("Hello! This is my silly thread!\n");
		return 0;
	}
};


void main()
{
	// This doesn't work!
	/* CThread thread; */

	// This works fine!
	CMySillyThread sillyThread;
	sillyThread.StartThread();
}