// Function templates...
/*
// min for ints
int min( int a, int b )
{
	if ( a < b )
		return a;
	else
		return b;
}

// min for longs
long min( long a, long b )
{
	if ( a < b )
		return a;
	else
		return b;
}

// min for chars
char min( char a, char b )
{
	if ( a < b )
		return a;
	else
		return b;
}

// min for floats
float min( float a, float b )
{
	if ( a < b )
		return a;
	else
		return b;
}
*/
template <class T>
T min( T a, T b )
{
	if ( a < b )
		return a;
	else
		return b;
}


// Class templates...
template <class T, int size>
class CSafeArray
{
	public:
		CSafeArray() : m_size(size)
		{
		}

		bool SetValue(int index, T value)
		{
			if (index >= m_size)
				return false;

			m_array[index] = value;
			return true;
		}

	private:
		int m_size;
		T m_array[size];
};

void main()
{
	// Function templates...
	int a = 3;
	int b = 4;

	int c = min(a, b);

	// Class templates...
	bool bRetValue;

	CSafeArray<int, 10> myIntArray;
	bRetValue = myIntArray.SetValue(10, 40);

	CSafeArray<float, 100> myFloatArray;
	bRetValue = myFloatArray.SetValue(54, 43.4f);
}